<?php
require_once 'config.php';
if (!isLoggedIn()) {
    header('Location: login.php');
    exit();
}
require_once 'header.php';

// جلب جميع الخدمات من قاعدة البيانات
$services = [];
$sql = "SELECT * FROM services";
$result = $conn->query($sql);
if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $row['features'] = array_map('trim', explode(',', $row['features']));
        $row['popular'] = (bool)$row['popular'];
        $services[] = $row;
    }
}

// تصنيف الخدمات حسب الفئة
$groupedServices = [];
foreach ($services as $srv) {
    $cat = $srv['category'] ?: 'other';
    if (!isset($groupedServices[$cat])) $groupedServices[$cat] = [];
    $groupedServices[$cat][] = $srv;
}

// التصنيفات (ثابتة)
$categories = [
    ["id" => "facebook", "name" => "خدمات فيسبوك"],
    ["id" => "instagram", "name" => "خدمات انستجرام"],
    ["id" => "tiktok", "name" => "خدمات تيك توك"],
    ["id" => "youtube", "name" => "خدمات يوتيوب"],
    ["id" => "telegram", "name" => "خدمات تليجرام"],
    ["id" => "twitter", "name" => "خدمات تويتر"],
    ["id" => "spotify", "name" => "خدمات سبوتيفاي"],
    ["id" => "reports", "name" => "إبلاغات - ريبورت"],
    ["id" => "canva", "name" => "تفعيل كانفا برو"],
    ["id" => "other", "name" => "خدمات أخرى"],
];

// معالجة الطلب
$success = false;
$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $category = $_POST['serviceCategory'] ?? '';
    $serviceType = $_POST['serviceType'] ?? '';
    $link = trim($_POST['link'] ?? '');
    $quantity = trim($_POST['quantity'] ?? '');
    $notes = trim($_POST['notes'] ?? '');
    $user_id = isset($_SESSION['user_id']) ? intval($_SESSION['user_id']) : null;

    if (!$category || !$serviceType || !$link || !$quantity) {
        $error = 'يرجى ملء جميع الحقول المطلوبة';
    } else {
        // جلب اسم الخدمة من id
        $serviceTitle = '';
        foreach ($services as $srv) {
            if ($srv['id'] == $serviceType) {
                $serviceTitle = $srv['title'];
                break;
            }
        }

        // جلب اسم المستخدم من الجلسة أو من قاعدة البيانات إذا لم يكن موجودًا
        if (isset($_SESSION['username']) && $_SESSION['username']) {
            $username = $_SESSION['username'];
        } elseif (isset($_SESSION['user_id'])) {
            $stmtUser = $conn->prepare("SELECT username FROM users WHERE id = ?");
            $stmtUser->bind_param('i', $_SESSION['user_id']);
            $stmtUser->execute();
            $stmtUser->bind_result($fetched_username);
            if ($stmtUser->fetch()) {
                $username = $fetched_username;
            } else {
                $username = 'غير معروف';
            }
            $stmtUser->close();
        } else {
            $username = 'غير معروف';
        }

        $stmt = $conn->prepare("INSERT INTO orders (user_id, category, service_name, link, amount, notes, created_at) VALUES (?, ?, ?, ?, ?, ?, NOW())");
        if ($stmt === false) {
            throw new Exception('Prepare order statement failed: ' . $conn->error);
        }
        $stmt->bind_param('isssds', $user_id, $category, $serviceTitle, $link, $quantity, $notes);
        if ($stmt->execute()) {
            $success = true;
            // إرسال إشعار إلى تليجرام
            $botToken = '7712958701:AAGBAqEYx2gvEPCOHFWVI0aCG_eERK9Ql0U';
            $chatId = '1278161988';
            $msg = "🛒 طلب خدمة جديد%0A";
            $msg .= "المستخدم: $username%0A";
            $msg .= "الخدمة: $serviceTitle%0A";
            $msg .= "الرابط: $link%0A";
            $msg .= "الكمية: $quantity%0A";
            $msg .= "ملاحظات: $notes%0A";
            $msg .= "التاريخ: ".date('Y-m-d H:i:s');
            @file_get_contents("https://api.telegram.org/bot$botToken/sendMessage?chat_id=$chatId&text=$msg");
        } else {
            $error = 'حدث خطأ أثناء حفظ الطلب: ' . $conn->error;
        }
        $stmt->close();
    }
}
?>

<div class="container py-5" style="max-width:600px;">
    <div class="card bg-dark border-0 shadow-lg">
        <div class="card-header bg-transparent border-0 pb-0">
            <h2 class="fw-bold text-white mb-2">طلب خدمة جديدة</h2>
            <span class="badge bg-gradient" style="background: linear-gradient(90deg, #e14eca 0%, #7367f0 100%); color:#fff;">سريع وسهل</span>
        </div>
        <div class="card-body">
            <?php if ($success): ?>
                <div class="alert alert-success">تم تقديم الطلب بنجاح! سيتم معالجة طلبك في أقرب وقت ممكن.</div>
            <?php elseif ($error): ?>
                <div class="alert alert-danger"> <?= htmlspecialchars($error) ?> </div>
            <?php endif; ?>
            <!-- صندوق السعر خارج الفورم -->
            <div id="globalServicePrice" class="alert alert-info p-3 mb-3 text-center fw-bold" style="display:none; max-width:600px; margin:auto; background: linear-gradient(90deg, #7367f0 0%, #e14eca 100%); color:#fff; font-size: 1.2rem;"></div>
            <form method="post" class="text-end" id="orderForm" autocomplete="off">
                <!-- اختيار الفئة -->
                <div class="mb-3">
                    <label for="serviceCategory" class="form-label text-white">فئة الخدمة <span class="text-danger">*</span></label>
                    <select class="form-select bg-w text-white border-secondary" name="serviceCategory" id="serviceCategory" required>
                        <option value="">اختر فئة الخدمة</option>
                        <?php foreach ($categories as $cat): ?>
                            <option value="<?= $cat['id'] ?>" <?= (isset($_POST['serviceCategory']) && $_POST['serviceCategory'] == $cat['id']) ? 'selected' : '' ?>><?= $cat['name'] ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <!-- نوع الخدمة -->
                <div class="mb-3">
                    <label for="serviceType" class="form-label">نوع الخدمة <span class="text-danger">*</span></label>
                    <select class="form-select bg-dark text-white border-secondary" name="serviceType" id="serviceType" required <?= empty($_POST['serviceCategory']) ? 'disabled' : '' ?>>
                        <option value="">اختر نوع الخدمة</option>
                        <?php
                        $selectedCat = $_POST['serviceCategory'] ?? '';
                        $selectedServiceId = $_POST['serviceType'] ?? '';
                        if ($selectedCat && isset($groupedServices[$selectedCat])) {
                            foreach ($groupedServices[$selectedCat] as $srv) {
                                $selected = ($selectedServiceId == $srv['id']) ? 'selected' : '';
                                echo '<option value="' . $srv['id'] . '" ' . $selected . '>' . htmlspecialchars($srv['title']) . '</option>';
                            }
                        }
                        ?>
                    </select>
                </div>
                <!-- السعر (يظهر عند اختيار نوع الخدمة) -->
                <!-- تم نقل صندوق السعر خارج الفورم -->
                <div class="form-label">سعر الخدمة</div>
                <!-- رابط الحساب -->
                <div class="mb-3">
                    <label for="link" class="form-label">رابط الحساب <span class="text-danger">*</span></label>
                    <input type="url" class="form-control bg-dark text-white border-secondary" name="link" id="link" placeholder="https://instagram.com/username" value="<?= htmlspecialchars($_POST['link'] ?? '') ?>" required>
                </div>
                <!-- الكمية -->
                <div class="mb-3">
                    <label for="quantity" class="form-label">الكمية المطلوبة <span class="text-danger">*</span></label>
                    <input type="number" class="form-control bg-dark text-white border-secondary" name="quantity" id="quantity" placeholder="مثال: 1000" value="<?= htmlspecialchars($_POST['quantity'] ?? '') ?>" required>
                </div>
                <!-- ملاحظات إضافية -->
                <div class="mb-3">
                    <label for="notes" class="form-label">ملاحظات إضافية (اختياري)</label>
                    <textarea class="form-control bg-dark text-white border-secondary" name="notes" id="notes" rows="3" placeholder="أي ملاحظات إضافية تريد إضافتها للطلب"><?= htmlspecialchars($_POST['notes'] ?? '') ?></textarea>
                </div>
                <!-- ملاحظات هامة -->
                <div class="alert alert-warning">
                    <ul class="mb-0">
                        <li>تأكد من صحة الرابط قبل تقديم الطلب</li>
                        <li>يجب أن يكون الحساب عاماً وليس خاصاً</li>
                        <li>لا تضع طلباً جديداً قبل اكتمال الطلب السابق</li>
                    </ul>
                </div>
                <button type="submit" class="btn btn-primary w-100" id="submitBtn">تقديم الطلب</button>
            </form>
        </div>
    </div>
</div>

<script>
// بيانات الخدمات من PHP
const groupedServices = <?= json_encode($groupedServices, JSON_UNESCAPED_UNICODE); ?>;
const serviceSelect = document.getElementById('serviceType');
const categorySelect = document.getElementById('serviceCategory');
const globalPriceDiv = document.getElementById('globalServicePrice');
let priceTimeout = null;

// عند تغيير الفئة: إعادة إخفاء السعر
categorySelect.addEventListener('change', function() {
    serviceSelect.innerHTML = '<option value="">اختر نوع الخدمة</option>';
    if (this.value && groupedServices[this.value]) {
        groupedServices[this.value].forEach(srv => {
            const opt = document.createElement('option');
            opt.value = srv.id;
            opt.textContent = srv.title;
            serviceSelect.appendChild(opt);
        });
        serviceSelect.disabled = false;
    } else {
        serviceSelect.disabled = true;
    }
    globalPriceDiv.style.display = 'none';
    if (priceTimeout) clearTimeout(priceTimeout);
});

// عند تغيير نوع الخدمة: عرض السعر ثم إخفاؤه بعد ثانيتين
serviceSelect.addEventListener('change', function() {
    const cat = categorySelect.value;
    const srvId = this.value;
    if (cat && srvId && groupedServices[cat]) {
        const srv = groupedServices[cat].find(s => s.id == srvId);
        if (srv) {
            if (srv.price !== undefined && srv.price !== null && srv.price !== '') {
                globalPriceDiv.innerHTML = `سعر الخدمة: <strong>${srv.price}</strong> $`;
            } else {
                globalPriceDiv.innerHTML = '<span class="text-danger">لم يتم تحديد سعر لهذه الخدمة</span>';
            }
            globalPriceDiv.style.display = 'block';
            if (priceTimeout) clearTimeout(priceTimeout);
            priceTimeout = setTimeout(() => {
                globalPriceDiv.style.display = 'none';
            }, 15000);
        } else {
            globalPriceDiv.style.display = 'none';
        }
    } else {
        globalPriceDiv.style.display = 'none';
    }
});

// عند تحميل الصفحة: إخفاء السعر
window.addEventListener('DOMContentLoaded', function() {
    globalPriceDiv.style.display = 'none';
    if (priceTimeout) clearTimeout(priceTimeout);
});
</script>

<?php require_once 'footer.php'; ?> 